/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

//by maq/floppy
float gauss(float s, float d, float r)
{
		return (1.0/(sqrt(2.0*3.1415)*s))*exp(-pow(d-r,2.0)/(s*s));
}	
float bgauss(float s, float d, float r)
{
	if(d>=r)
		return gauss(s,d,r);
	else
		return gauss(s,0.0,0.0);
}
void main(void)
{
	vec2 uv = (gl_FragCoord.xy / iResolution.xy-0.5);
	uv.y*=0.66;
	vec2 point = vec2(-0.13,-0.03);
	float s=0.03;
	float r=0.1;
	// moon	
	float d = length(uv-point);
	d=bgauss(s,d,r);
	// earth shadow
	vec2 point2 = point+vec2(-0.1+sin(iGlobalTime*0.02),0.01);
	float d2 = length(uv-point2);
	d2=bgauss(s,d2,r);
	d=min(d,1.0-d2);
	// moon texture
	d*=(1.0+2.0*length(uv-point));
	d=d*(0.9+(0.3-d)*0.3*texture2D(iChannel0,uv+iGlobalTime*0.01).y);

	//stars
	d=max(d,bgauss(0.0005,length(uv-vec2(0.01,0.112)),0.0)   );
	d=max(d,bgauss(0.002,length(uv-vec2(-0.33,0.2)),0.001)   );
	d=max(d,bgauss(0.001,length(uv-vec2(0.2,-0.2)),0.0)   );
	d=max(d,bgauss(0.002*(0.1+0.3*texture2D(iChannel0,uv+iGlobalTime*0.1).x),length(uv-vec2(0.444,0.2)),0.0)   );
	d=max(d,bgauss(0.001*(0.1+0.3*texture2D(iChannel0,uv+iGlobalTime*0.1).y),length(uv-vec2(-0.4,-0.0)),0.0)   );
	
	vec3 col=vec3(d);	
	gl_FragColor = vec4(col,1.0);// vec4(uv,0.5+0.5*sin(iGlobalTime),1.0);
}